package topdown.operator;

import topdown.data_structures.*;
import topdown.concrete_operator.*;
import topdown.term.Term;

import java.util.ArrayList;
import java.util.List;

public class Union implements Operator {
    private final List<Operator> operators;

    public Union(List<Operator> operators) {
        this.operators = operators;
    }

    @Override
    public ConcreteOperator instance() {
        List<ConcreteOperator> concreteOperators = new ArrayList<>();
        for (Operator op : operators) {
            concreteOperators.add(op.instance());
        }

        ConcreteUnion result = new ConcreteUnion(
                concreteOperators
        );
        result.reset();
        return result;
    }

    @Override
    public ConcreteOperator instance(int U, int L) {
        if (U <= 0 || L <= 0) return new EmptyOperator();

        List<ConcreteOperator> concreteOperators = new ArrayList<>();
        for (Operator op : operators) {
            concreteOperators.add(op.instance(U, L));
        }

        ConcreteUnion result = new ConcreteUnion(
                concreteOperators
        );

        return result;
    }

    @Override
    public boolean changes(int U, int L) {
        for (Operator op : operators) {
            if (op.changes(U, L)) return true;
        }

        return false;
    }

    @Override
    public boolean changes(int U) {
        for (Operator op : operators) {
            if (op.changes(U)) return true;
        }

        return false;
    }
}
